---
generated_at: 2026-01-22 11:00:00
metrics:
  claims_total: 20
  claims_with_evidence: 19
  claims_without_evidence: 1
confidence_derived: 0.95
---

# 根拠レポート：277-Web IDE

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.95**
  - 根拠あり：19 / 20、根拠なし：1
- 優先レビュー（高）
  1. **C-20**: shared/_ide_root.html.hamlの詳細未確認

## 2) 参照した情報（Evidence一覧）

- E-01: `app/views/ide/index.html.haml`（6行）
- E-02: `app/controllers/ide_controller.rb`（85行）
- E-03: `app/helpers/ide_helper.rb`（91行）
- E-04: `docs/code-to-docs/画面一覧/画面一覧.csv`（278行目）
- E-05: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv`（334-337行目）

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 画面名は「Web IDE」である | E-04 | ○ |
| C-02 | テンプレートファイルはindex.html.hamlである | E-01 | ○ |
| C-03 | 機能No.141「Web IDE」に関連 | E-05 | ○ |
| C-04 | 機能No.16「ファイル編集」、No.17「ファイル作成」に補助機能として関連 | E-05 | ○ |
| C-05 | fullscreenレイアウトを使用 | E-02（27行目） | ○ |
| C-06 | authorize_read_project!でプロジェクト読み取り権限チェック | E-02（10行目） | ○ |
| C-07 | ensure_web_ide_oauth_application!でOAuthアプリ確認 | E-02（11行目, 53-55行目） | ○ |
| C-08 | fork_infoメソッドでフォーク情報を計算 | E-02（57-69行目） | ○ |
| C-09 | push_code権限がない場合はフォーク情報を返す | E-02（58行目） | ○ |
| C-10 | ide_dataヘルパーでフロントエンドにデータを渡す | E-01（3行目）, E-03（5-21行目） | ○ |
| C-11 | new-web-ide-help-page-pathデータ属性あり | E-03（8行目） | ○ |
| C-12 | sign-in-path、sign-out-pathデータ属性あり | E-03（9-10行目） | ○ |
| C-13 | fork-info、branch-name、file-pathデータ属性あり | E-03（16-18行目） | ○ |
| C-14 | project-pathデータ属性あり | E-03（82行目） | ○ |
| C-15 | editor-fontでフォント設定（JSON） | E-03（35-55行目, 84行目） | ○ |
| C-16 | エディタフォントはGitLab Mono | E-03（40-41行目） | ○ |
| C-17 | client-id、callback-urlsでOAuth設定 | E-03（67-70行目） | ○ |
| C-18 | web_ide_viewedイベントトラッキング | E-02（22行目） | ○ |
| C-19 | Loading messageはLoading the Web IDE | E-01（5行目） | ○ |
| C-20 | shared/_ide_root.html.hamlでVue.jsアプリ起動 | E-01（5行目の参照のみ）、パーシャル未確認 | △ |

## 4) 不足情報（Unknown / Missing）

- **shared/_ide_root.html.hamlの詳細未確認**
  - `app/views/shared/_ide_root.html.haml`の内容を直接確認していない
  - Vue.jsアプリケーションのマウントポイントの詳細が未確認

## 5) リスクフラグ（レビュー観点）

- **0: 低リスク** - 主要な処理フローはソースコードから確認済み、フロントエンドの詳細はVue.js側で実装

## 6) レビュアーチェックリスト（最小）

- [ ] shared/_ide_root.html.hamlの詳細確認
- [ ] フォーク作成フローの動作確認
- [ ] OAuthアプリケーション設定がない場合の動作確認
- [ ] 拡張機能マーケットプレイス連携の動作確認
